/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;

public class UDDIObjectCache {
    private Hashtable cache = new Hashtable();
    private LinkedList list = new LinkedList();
    Collection registryServices;
    private static final int MAX_CACHE_SIZE = 150;

    public UDDIObjectCache(RegistryServiceImpl registryServiceImpl) {
        if (this.registryServices == null) {
            this.registryServices = new ArrayList();
        }
        this.addToRegistryServices(registryServiceImpl);
    }

    void addObjectToCache(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        if (registryObjectImpl.getServiceId() == null) {
            registryObjectImpl.setServiceId(string);
        }
        this.add(registryObjectImpl);
    }

    void addObjectsToCache(Collection collection, String string) throws JAXRException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RegistryObjectImpl)) continue;
            RegistryObjectImpl registryObjectImpl = (RegistryObjectImpl)e;
            if (registryObjectImpl.getServiceId() == null) {
                registryObjectImpl.setServiceId(string);
            }
            if (registryObjectImpl.getServiceId() == null) {
                registryObjectImpl.setServiceId(string);
            }
            this.add(registryObjectImpl);
        }
    }

    RegistryObject fetchObjectFromCache(String string) throws JAXRException {
        return (RegistryObject)this.cache.get(string);
    }

    public void fetchObject(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        Object var3_3 = null;
        Object var4_4 = null;
        if (registryObjectImpl != null) {
            RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)registryObjectImpl.getRegistryService();
            if (registryServiceImpl.getConnection().useCache() && registryObjectImpl.isLoaded()) {
                return;
            }
            registryServiceImpl.getUDDIMapper().getRegistryObject(registryObjectImpl);
            if (registryServiceImpl.getConnection().useCache()) {
                this.add(registryObjectImpl);
            }
            registryObjectImpl.setStatusFlags(true, true, false);
        }
        if (registryObjectImpl != null) {
            registryObjectImpl.setStatusFlags(true, true, false);
        }
    }

    void removeObjectFromCache(String string) {
        RegistryObjectImpl registryObjectImpl;
        if (this.list.size() > 0) {
            this.list.remove(string);
        }
        if ((registryObjectImpl = (RegistryObjectImpl)this.cache.remove(string)) != null) {
            registryObjectImpl.setIsDeleted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(RegistryObjectImpl registryObjectImpl) throws JAXRException {
        String string = registryObjectImpl.getKey().getId();
        Object object = this.list;
        synchronized (object) {
            this.list.remove(string);
            this.list.addFirst(string);
        }
        if (this.cache.size() >= 150) {
            object = null;
            Serializable serializable = this.list;
            synchronized (serializable) {
                object = (String)this.list.removeLast();
            }
            serializable = (RegistryObjectImpl)this.cache.remove(object);
        }
        object = this;
        synchronized (object) {
            this.cache.put(string, registryObjectImpl);
        }
    }

    public void fetchAssociations(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        Object object;
        Object object2;
        Object object3;
        BulkResponse bulkResponse = null;
        if (registryObjectImpl != null) {
            object3 = registryObjectImpl.getKey().getId();
            if (object3 == null) {
                return;
            }
            if (registryObjectImpl.areAssociationsLoaded()) {
                return;
            }
            object2 = registryObjectImpl.getServiceId();
            object = this.getService((String)object2);
            bulkResponse = ((RegistryServiceImpl)object).getUDDIMapper().findAssociations(null, (String)object3, null, null);
        }
        if (bulkResponse.getExceptions() == null) {
            object3 = bulkResponse.getCollection();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (RegistryObjectImpl)object2.next();
                this.add((RegistryObjectImpl)object);
                ((RegistryObjectImpl)object).setAssociationsLoaded(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushCache() {
        UDDIObjectCache uDDIObjectCache = this;
        synchronized (uDDIObjectCache) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToRegistryServices(RegistryServiceImpl registryServiceImpl) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            if (!this.registryServices.contains(registryServiceImpl)) {
                this.registryServices.add(registryServiceImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryServiceImpl getService(String string) {
        Collection collection = this.registryServices;
        synchronized (collection) {
            Iterator iterator = this.registryServices.iterator();
            while (iterator.hasNext()) {
                RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)iterator.next();
                if (!registryServiceImpl.getServiceId().equals(string)) continue;
                return registryServiceImpl;
            }
        }
        return null;
    }
}

