package com.nec.webotx.webservice.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;

import com.sun.xml.registry.uddi.infomodel.EmailAddressImpl;

public class JAXRQuerySample {

	Connection connection = null;
	public static void main(String[] args) {
		ResourceBundle bundle =
			ResourceBundle.getBundle(
				"com.nec.webotx.webservice.sample.JAXRSample");
		String queryURL = bundle.getString("query.url");
		JAXRQuerySample queryClient = new JAXRQuerySample();
		queryClient.makeConnection(queryURL);
		queryClient.execute(bundle.getString("query.string"));
	}

	public void makeConnection(String queryURL) {
		ResourceBundle bundle =
			ResourceBundle.getBundle(
				"com.nec.webotx.webservice.sample.JAXRSample");
		Properties props = new Properties();
		props.setProperty("javax.xml.registry.queryManagerURL", queryURL);
		try {
			ConnectionFactory factory = ConnectionFactory.newInstance();
			factory.setProperties(props);
			connection = factory.createConnection();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void execute(String query) {
		try {
			RegistryService rs = connection.getRegistryService();
			BusinessQueryManager bqm = rs.getBusinessQueryManager();
			ResourceBundle bundle =
				ResourceBundle.getBundle(
					"com.nec.webotx.webservice.sample.JAXRSample");

			Collection patterns = new ArrayList();
			patterns.add("%" + query + "%");
			System.out.println("start");
			BulkResponse br =
				bqm.findOrganizations(null, patterns, null, null, null, null);
			Collection collection = br.getCollection();
			System.out.println("[RESULT]");
			Iterator iter = collection.iterator();
			while (iter.hasNext()) {
				System.out.println("----------");
				
				Iterator ite;

				Organization org = (Organization) iter.next();
				System.out.println("Org Name: " + org.getName().getValue());
				System.out.println(
					"Org Description: " + org.getDescription().getValue());

				System.out.println(
					"PersonName: "
						+ org.getPrimaryContact().getPersonName().getFullName());
				Collection tel =
					org.getPrimaryContact().getTelephoneNumbers("");
				ite = tel.iterator();
				while (ite.hasNext()) {
					TelephoneNumber number = (TelephoneNumber) ite.next();
					System.out.println(
						"TelephoneNumber: " + number.getNumber());
				}
				Collection email = org.getPrimaryContact().getEmailAddresses();
				ite = email.iterator();
				while (ite.hasNext()) {
					EmailAddressImpl address = (EmailAddressImpl) ite.next();
					System.out.println(
						"EmailAddresses: " + address.getAddress());
				}
				Collection classifications = org.getClassifications();
				ite = classifications.iterator();
				while (ite.hasNext()) {
					Classification classification = (Classification) ite.next();
					System.out.println(
						"Classification Name: "
							+ classification.getName().getValue());
					System.out.println(
						"Classification Value: " + classification.getValue());

				}

				Collection services = org.getServices();
				ite = services.iterator();
				while (ite.hasNext()) {
					Service service = (Service) ite.next();
					System.out.println(
						"Service Name: " + service.getName().getValue());
					System.out.println(
						"Service Description: "
							+ service.getDescription().getValue());
					Collection serviceBindings = service.getServiceBindings();
					Iterator bindings = serviceBindings.iterator();
					while (bindings.hasNext()) {
						ServiceBinding binding =
							(ServiceBinding) bindings.next();
						System.out.println(
							"ServiceEndpointURI: " + binding.getAccessURI());
						Collection specLinks = binding.getSpecificationLinks();
						if (specLinks.size() > 0) {
							SpecificationLink link =
								(SpecificationLink) specLinks.iterator().next();
							Concept concept =
								(Concept) link.getSpecificationObject();
							System.out.println(
								"Concept name: "
									+ concept.getName().getValue());
							Collection links = concept.getExternalLinks();
							if (links.size() > 0) {
								ExternalLink extlink =
									(ExternalLink) links.iterator().next();
								System.out.println(
									"WSDL URI: " + extlink.getExternalURI());
							} else
								continue;
						} else
							continue;
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				connection.close();
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

}