package com.nec.webotx.webservice.sample;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAAJClient {
	
	private static final String URL = "http://localhost/saaj/sample";
	private static final String NS = "http://sample/WebOTX";
	private static final String PREFIX = "n";
	private static final String ELEMENT1 = "data";
	private static final String ELEMENT2 = "No";

	public static void main(String[] args) throws Exception {
		SAAJClient client = new SAAJClient();
		client.invoke(client.createMessage(), System.out);
		System.out.println();
		System.out.println();
		client.invoke(client.createMessage("sample.xml"), System.out);
	}
	
	private void invoke(SOAPMessage message, OutputStream out) {
		try {
			SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
			SOAPConnection con = scf.createConnection();
			SOAPMessage reply = con.call(message, URL);

			SOAPBody body = reply.getSOAPBody();
			Iterator ite = body.getChildElements();
			while (ite.hasNext()) {
				Node node = (Node) ite.next();
				Source source = new DOMSource(node);
				TransformerFactory factory = TransformerFactory.newInstance();
				Transformer transformer = factory.newTransformer();
				Result output = new StreamResult(out);
				transformer.transform(source, output);
			}
			con.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private SOAPMessage createMessage() throws SOAPException {
		MessageFactory mf = MessageFactory.newInstance();
		SOAPMessage message = mf.createMessage();
		SOAPEnvelope env = message.getSOAPPart().getEnvelope();
		SOAPBody body = env.getBody();
		
		Name name = env.createName(ELEMENT1, PREFIX, NS);
		SOAPBodyElement bodyElement = body.addBodyElement(name);
		name = env.createName(ELEMENT2, PREFIX, NS);
		bodyElement.addChildElement(name).addTextNode("001");
		return message;
	}

	private SOAPMessage createMessage(String filelocation)
		throws Exception {
		MessageFactory mf = MessageFactory.newInstance();
		SOAPMessage message = mf.createMessage();
		SOAPEnvelope env = message.getSOAPPart().getEnvelope();
		SOAPBody body = env.getBody();
		
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setNamespaceAware(true);
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(filelocation);
		body.addDocument(doc);
		return message;
	}

}
