/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.literal;

import com.nec.webotx.webservice.xml.rpc.encoding.CombinedSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationState;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPInstanceBuilder;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerCallback;
import com.nec.webotx.webservice.xml.rpc.encoding.SerializerConstants;
import com.nec.webotx.webservice.xml.rpc.encoding.xsd.XSDConstants;
import com.nec.webotx.webservice.xml.rpc.streaming.Attributes;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReaderUtil;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterUtil;
import com.nec.webotx.webservice.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public abstract class LiteralObjectSerializerBase
implements SerializerConstants,
CombinedSerializer {
    protected QName type;
    protected boolean isNullable;
    protected String encodingStyle;
    protected boolean encodeType = false;

    protected LiteralObjectSerializerBase(QName type, boolean isNullable, String encodingStyle) {
        this.init(type, isNullable, encodingStyle, false);
    }

    protected LiteralObjectSerializerBase(QName type, boolean isNullable, String encodingStyle, boolean encodeType) {
        this.init(type, isNullable, encodingStyle, encodeType);
    }

    private void init(QName type, boolean isNullable, String encodingStyle, boolean encodeType) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.isNullable = isNullable;
        this.encodingStyle = encodingStyle;
        this.encodeType = encodeType;
    }

    public QName getXmlType() {
        return this.type;
    }

    public boolean getEncodeType() {
        return false;
    }

    public CombinedSerializer getInnermostSerializer() {
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void serialize(Object value, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        try {
            this.internalSerialize(value, name, writer, context);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            return this.internalDeserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext context) throws DeserializationException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void internalSerialize(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        context.beginSerializing(obj);
        writer.startElement(name != null ? name : this.type);
        boolean pushedEncodingStyle = false;
        if (this.encodingStyle != null) {
            pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        }
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        if (obj == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        } else {
            this.writeAdditionalNamespaceDeclarations(obj, writer);
            this.doSerializeAttributes(obj, writer, context);
            this.doSerialize(obj, writer, context);
        }
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
        context.doneSerializing(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            this.verifyType(reader);
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            return object;
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    protected void verifyType(XMLReader reader) throws Exception {
        QName actualType = LiteralObjectSerializerBase.getType(reader);
        if (actualType != null && !actualType.equals(this.type) && !this.isAcceptableType(actualType)) {
            throw new DeserializationException("xsd.unexpectedElementType", new Object[]{this.type.toString(), actualType.toString()});
        }
    }

    protected boolean isAcceptableType(QName actualType) {
        return false;
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    protected abstract void doSerialize(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract void doSerializeAttributes(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract Object doDeserialize(XMLReader var1, SOAPDeserializationContext var2) throws Exception;

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }

    public static QName getType(XMLReader reader) throws Exception {
        QName type = null;
        Attributes attrs = reader.getAttributes();
        String typeVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeVal != null) {
            type = XMLReaderUtil.decodeQName(reader, typeVal);
        }
        return type;
    }

    public static SOAPDeserializationState registerWithMemberState(Object instance, SOAPDeserializationState state, Object member, int memberIndex, SOAPInstanceBuilder builder) {
        try {
            SOAPDeserializationState deserializationState = state == null ? new SOAPDeserializationState() : state;
            deserializationState.setInstance(instance);
            if (deserializationState.getBuilder() == null) {
                if (builder == null) {
                    throw new IllegalArgumentException();
                }
                deserializationState.setBuilder(builder);
            }
            SOAPDeserializationState memberState = (SOAPDeserializationState)member;
            memberState.registerListener(deserializationState, memberIndex);
            return deserializationState;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }
}

