/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.config.parser;

import com.nec.webotx.webservice.xml.rpc.processor.config.ModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.NoMetadataModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.Constants;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.HandlerChainInfoData;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ModelInfoParser;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ParserUtil;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import javax.xml.namespace.QName;

public class NoMetadataModelInfoParser
extends ModelInfoParser {
    public NoMetadataModelInfoParser(ProcessorEnvironment env) {
        super(env);
    }

    public ModelInfo parse(XMLReader reader) {
        NoMetadataModelInfo modelInfo = new NoMetadataModelInfo();
        String location = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
        modelInfo.setLocation(location);
        String interfaceName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "interfaceName");
        modelInfo.setInterfaceName(interfaceName);
        String servantName = ParserUtil.getNonEmptyAttribute(reader, "servantName");
        modelInfo.setServantName(servantName);
        String serviceInterfaceName = ParserUtil.getNonEmptyAttribute(reader, "serviceInterfaceName");
        modelInfo.setServiceInterfaceName(serviceInterfaceName);
        QName serviceName = ParserUtil.getQNameAttribute(reader, "serviceName");
        modelInfo.setServiceName(serviceName);
        QName portName = ParserUtil.getQNameAttribute(reader, "portName");
        modelInfo.setPortName(portName);
        boolean gotHandlerChains = false;
        boolean gotNamespaceMappingRegistry = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                if (gotHandlerChains) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                HandlerChainInfoData data = this.parseHandlerChainInfoData(reader);
                modelInfo.setClientHandlerChainInfo(data.getClientHandlerChainInfo());
                modelInfo.setServerHandlerChainInfo(data.getServerHandlerChainInfo());
                gotHandlerChains = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_NAMESPACE_MAPPING_REGISTRY)) {
                if (gotNamespaceMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.setNamespaceMappingRegistry(this.parseNamespaceMappingRegistryInfo(reader));
                gotNamespaceMappingRegistry = true;
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return modelInfo;
    }
}

