/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator.nodes;

import com.nec.webotx.webservice.xml.rpc.processor.config.Configuration;
import com.nec.webotx.webservice.xml.rpc.processor.config.RmiModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.generator.nodes.JaxRpcMappingNode;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.java.JavaStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralContentMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralElementMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPStructureType;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaXmlTypeMappingNode
extends JaxRpcMappingNode {
    private static final String MYNAME = "JavaXmlTypeMappingNode";

    public Node write(Node parent, String nodeName, AbstractType type, Configuration config, boolean isSimpleType) throws Exception {
        if (isSimpleType) {
            return this.writeSimpleType(parent, nodeName, type);
        }
        return this.writeComplexType(parent, nodeName, type, config);
    }

    private Node writeComplexType(Node parent, String nodeName, AbstractType type, Configuration config) {
        block20: {
            Element node;
            block19: {
                node = null;
                if (type instanceof RPCRequestOrderedStructureType) {
                    return node;
                }
                if (type instanceof RPCRequestUnorderedStructureType) {
                    return node;
                }
                if (type instanceof RPCResponseStructureType) {
                    return node;
                }
                this.debug(MYNAME, "ComplexType = " + type.getClass().getName());
                if (!(type instanceof SOAPStructureType)) break block19;
                node = JavaXmlTypeMappingNode.appendChild(parent, nodeName);
                SOAPStructureType soapStructType = (SOAPStructureType)type;
                QName qname = soapStructType.getName();
                String namespaceURI = qname.getNamespaceURI();
                JavaXmlTypeMappingNode.appendTextChild((Node)node, "java-type", soapStructType.getJavaType().getName());
                Element rootTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "root-type-qname", "typeNS:" + qname.getLocalPart());
                rootTypeNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typeNS", namespaceURI);
                JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "complexType");
                Iterator iter = soapStructType.getMembers();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (o != null) {
                        this.debug(MYNAME, "SOAPStructureMemberType = " + o.getClass().getName());
                    } else {
                        this.debug(MYNAME, "SOAPStructureMemberType == NULL");
                    }
                    SOAPStructureMember member = (SOAPStructureMember)o;
                    String memberName = member.getName().getLocalPart();
                    JavaStructureMember javaMember = member.getJavaStructureMember();
                    String javaMemberName = javaMember.getName();
                    Element variableMappingNode = JavaXmlTypeMappingNode.appendChild(node, "variable-mapping");
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "java-variable-name", javaMemberName);
                    if (javaMember.isPublic()) {
                        JavaXmlTypeMappingNode.forceAppendTextChild(variableMappingNode, "data-member", null);
                    }
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "xml-element-name", memberName);
                }
                break block20;
            }
            if (!(type instanceof LiteralStructuredType)) break block20;
            this.debug(MYNAME, "TYPE = " + type.getName() + "; ANONY = " + (String)type.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousTypeName"));
            node = JavaXmlTypeMappingNode.appendChild(parent, nodeName);
            LiteralStructuredType litStructType = (LiteralStructuredType)type;
            QName qname = litStructType.getName();
            String namespaceURI = qname.getNamespaceURI();
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "java-type", litStructType.getJavaType().getName());
            if (litStructType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousTypeName") == null) {
                if ((namespaceURI == null || "".equals(namespaceURI)) && config.getModelInfo() instanceof RmiModelInfo) {
                    namespaceURI = ((RmiModelInfo)config.getModelInfo()).getTypeNamespaceURI();
                }
                Element rootTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "root-type-qname", "typeNS:" + qname.getLocalPart());
                rootTypeNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typeNS", namespaceURI);
            } else {
                String name = namespaceURI + ":" + (String)litStructType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousTypeName");
                Element anonymousTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "anonymous-type-qname", name);
            }
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "complexType");
            JavaStructureType t = (JavaStructureType)litStructType.getJavaType();
            Iterator iter = t.getMembers();
            while (iter.hasNext()) {
                Element variableMappingNode;
                String javaMemberName;
                JavaStructureMember javaMember;
                String memberName;
                Object member;
                Object o = ((JavaStructureMember)iter.next()).getOwner();
                if (o != null) {
                    this.debug(MYNAME, "LiteralElementMemberType = " + o.getClass().getName());
                } else {
                    this.debug(MYNAME, "LiteralElementMemberType == NULL");
                }
                if (o instanceof LiteralWildcardMember) {
                    this.debug(MYNAME, "LiteralWildcardMember = " + o);
                    member = (LiteralWildcardMember)o;
                    memberName = ((LiteralWildcardMember)member).getExcludedNamespaceName();
                    javaMember = ((LiteralElementMember)member).getJavaStructureMember();
                    javaMemberName = javaMember.getName();
                    variableMappingNode = JavaXmlTypeMappingNode.appendChild(node, "variable-mapping");
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "java-variable-name", javaMemberName);
                    if (javaMember.isPublic()) {
                        JavaXmlTypeMappingNode.forceAppendTextChild(variableMappingNode, "data-member", null);
                    }
                    JavaXmlTypeMappingNode.forceAppendTextChild(variableMappingNode, "xml-wildcard", null);
                    continue;
                }
                if (o instanceof LiteralElementMember) {
                    member = (LiteralElementMember)o;
                    memberName = ((LiteralElementMember)member).getName().getLocalPart();
                    javaMember = ((LiteralElementMember)member).getJavaStructureMember();
                    javaMemberName = javaMember.getName();
                    variableMappingNode = JavaXmlTypeMappingNode.appendChild(node, "variable-mapping");
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "java-variable-name", javaMemberName);
                    if (javaMember.isPublic()) {
                        JavaXmlTypeMappingNode.forceAppendTextChild(variableMappingNode, "data-member", null);
                    }
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "xml-element-name", memberName);
                    continue;
                }
                if (o instanceof LiteralAttributeMember) {
                    member = (LiteralAttributeMember)o;
                    memberName = ((LiteralAttributeMember)member).getName().getLocalPart();
                    javaMember = ((LiteralAttributeMember)member).getJavaStructureMember();
                    javaMemberName = javaMember.getName();
                    variableMappingNode = JavaXmlTypeMappingNode.appendChild(node, "variable-mapping");
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "java-variable-name", javaMemberName);
                    if (javaMember.isPublic()) {
                        JavaXmlTypeMappingNode.forceAppendTextChild(variableMappingNode, "data-member", null);
                    }
                    JavaXmlTypeMappingNode.appendTextChild((Node)variableMappingNode, "xml-attribute-name", memberName);
                    continue;
                }
                if (o instanceof LiteralContentMember) continue;
                System.err.println("NOT SUPPORTED TYPE = " + o.getClass().getName());
            }
        }
        return null;
    }

    private Node writeSimpleType(Node parent, String nodeName, AbstractType type) {
        Element node = null;
        if (type instanceof SOAPEnumerationType) {
            node = JavaXmlTypeMappingNode.appendChild(parent, nodeName);
            SOAPEnumerationType soapEnumType = (SOAPEnumerationType)type;
            QName qname = type.getName();
            String namespaceURI = qname.getNamespaceURI();
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "java-type", soapEnumType.getJavaType().getName());
            Element rootTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "root-type-qname", "typeNS:" + qname.getLocalPart());
            rootTypeNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typeNS", namespaceURI);
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "simpleType");
        } else if (type instanceof LiteralEnumerationType) {
            node = JavaXmlTypeMappingNode.appendChild(parent, nodeName);
            LiteralEnumerationType litEnumType = (LiteralEnumerationType)type;
            QName qname = type.getName();
            String namespaceURI = qname.getNamespaceURI();
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "java-type", litEnumType.getJavaType().getName());
            if (litEnumType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousTypeName") == null) {
                Element rootTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "root-type-qname", "typeNS:" + qname.getLocalPart());
                rootTypeNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typeNS", namespaceURI);
            } else {
                String name = namespaceURI + ":" + (String)litEnumType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousTypeName");
                Element anonymousTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "anonymous-type-qname", name);
            }
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "simpleType");
        }
        return null;
    }

    public Node writeAnonymousArrayType(Node parent, String nodeName, LiteralStructuredType litStructType, Configuration config, boolean isSimpleType) {
        Element node = JavaXmlTypeMappingNode.appendChild(parent, nodeName);
        QName qname = litStructType.getName();
        String namespaceURI = qname.getNamespaceURI();
        String javaType = (String)litStructType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousArrayJavaType");
        JavaXmlTypeMappingNode.appendTextChild((Node)node, "java-type", javaType);
        String name = namespaceURI + ":" + (String)litStructType.getProperty("com.nec.webotx.webservice.xml.rpc.processor.model.AnonymousArrayTypeName");
        Element anonymousTypeNode = (Element)JavaXmlTypeMappingNode.appendTextChild((Node)node, "anonymous-type-qname", name);
        if (isSimpleType) {
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "simpleType");
        } else {
            JavaXmlTypeMappingNode.appendTextChild((Node)node, "qname-scope", "complexType");
        }
        return null;
    }
}

