/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator.writer;

import com.nec.webotx.webservice.xml.rpc.encoding.InternalEncodingConstants;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorConstants;
import com.nec.webotx.webservice.xml.rpc.processor.generator.Names;
import com.nec.webotx.webservice.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.nec.webotx.webservice.xml.rpc.processor.model.AbstractType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPArrayType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.nec.webotx.webservice.xml.rpc.processor.model.soap.SOAPType;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.ModelerConstants;
import com.nec.webotx.webservice.xml.rpc.processor.util.IndentingWriter;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class CollectionSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private CollectionInfo collectionInfo;
    private SOAPType dataType;
    private static final Map collectionTypes = new HashMap();
    public static final CollectionInfo COLLECTION_INFO = new CollectionInfo(ModelerConstants.COLLECTION_CLASSNAME, "CollectionInterfaceSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo LIST_INFO = new CollectionInfo(ModelerConstants.LIST_CLASSNAME, "CollectionInterfaceSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo SET_INFO = new CollectionInfo(ModelerConstants.SET_CLASSNAME, "CollectionInterfaceSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo VECTOR_INFO = new CollectionInfo(ModelerConstants.VECTOR_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo STACK_INFO = new CollectionInfo(ModelerConstants.STACK_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo LINKED_LIST_INFO = new CollectionInfo(ModelerConstants.LINKED_LIST_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo ARRAY_LIST_INFO = new CollectionInfo(ModelerConstants.ARRAY_LIST_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo HASH_SET_INFO = new CollectionInfo(ModelerConstants.HASH_SET_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo TREE_SET_INFO = new CollectionInfo(ModelerConstants.TREE_SET_CLASSNAME, "CollectionSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo MAP_INFO = new CollectionInfo(ModelerConstants.MAP_CLASSNAME, "MapInterfaceSerializer", SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo HASH_MAP_INFO = new CollectionInfo(ModelerConstants.HASH_MAP_CLASSNAME, "MapSerializer", null);
    public static final CollectionInfo TREE_MAP_INFO = new CollectionInfo(ModelerConstants.TREE_MAP_CLASSNAME, "MapSerializer", null);
    public static final CollectionInfo HASHTABLE_INFO = new CollectionInfo(ModelerConstants.HASHTABLE_CLASSNAME, "MapSerializer", null);
    public static final CollectionInfo PROPERTIES_INFO = new CollectionInfo(ModelerConstants.PROPERTIES_CLASSNAME, "MapSerializer", null);
    public static final CollectionInfo JAX_RPC_MAP_ENTRY_INFO = new CollectionInfo(ModelerConstants.JAX_RPC_MAP_ENTRY_CLASSNAME, "JAXRpcMapEntrySerializer", null);

    public CollectionSerializerWriter(SOAPType type, Names names) {
        super(type, names);
        this.dataType = type;
        this.collectionInfo = (CollectionInfo)collectionTypes.get(type.getName());
        String serializerName = this.collectionInfo.serializerName;
        this.serializerMemberName = names.getClassMemberName(serializerName, type);
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        SOAPSimpleType type = (SOAPSimpleType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String referenceable = type.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String multiRef = multiRefEncoding && type.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_COLLECTION) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_LIST) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_SET) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY)) {
            p.plnI(this.serializerName() + " " + serName + " = new " + this.collectionInfo.serializerName + "(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ");");
            p.pO();
        } else if (type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASH_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_TREE_MAP) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_HASHTABLE) || type.getName().equals(InternalEncodingConstants.QNAME_TYPE_PROPERTIES)) {
            StringBuffer elemName = new StringBuffer("elemName");
            this.declareType(p, elemName, InternalEncodingConstants.COLLECTION_ELEMENT_NAME, false, false);
            p.plnI(this.serializerName() + " " + serName + " = new " + this.collectionInfo.serializerName + "(" + typeName + ",");
            p.pln(this.collectionInfo.collectionClassName + ".class, " + encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", " + this.getSOAPVersionString() + ");");
            p.pO();
        } else {
            StringBuffer elemName = new StringBuffer("elemName");
            this.declareType(p, elemName, InternalEncodingConstants.COLLECTION_ELEMENT_NAME, false, false);
            StringBuffer elemType = new StringBuffer("elemType");
            this.declareType(p, elemType, this.collectionInfo.elementTypeName, false, false);
            p.plnI(this.serializerName() + " " + serName + " = new " + this.collectionInfo.serializerName + "(" + typeName + ",");
            p.pln(this.collectionInfo.collectionClassName + ".class, " + encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ", ");
            p.pln(elemName + ", " + elemType + ", " + ModelerConstants.OBJECT_CLASSNAME + ".class, " + this.getSOAPVersionString() + ");");
            p.pO();
        }
        if (type.isReferenceable()) {
            p.plnI(serName + " = new " + "ReferenceableSerializerImpl" + "(" + multiRef + ", " + serName + ", " + this.getSOAPVersionString() + ");");
            p.pO();
        }
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public static boolean handlesType(AbstractType type) {
        return collectionTypes.containsKey(type.getName());
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public AbstractType getBaseElementType() {
        SOAPType elemType = ((SOAPArrayType)this.type).getElementType();
        while (elemType instanceof SOAPArrayType) {
            elemType = ((SOAPArrayType)elemType).getElementType();
        }
        return elemType;
    }

    static {
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_COLLECTION, COLLECTION_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_LIST, LIST_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_SET, SET_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_VECTOR, VECTOR_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_STACK, STACK_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST, LINKED_LIST_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST, ARRAY_LIST_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_HASH_SET, HASH_SET_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_TREE_SET, TREE_SET_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_MAP, MAP_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_HASH_MAP, HASH_MAP_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_TREE_MAP, TREE_MAP_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_HASHTABLE, HASHTABLE_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_PROPERTIES, PROPERTIES_INFO);
        collectionTypes.put(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY, JAX_RPC_MAP_ENTRY_INFO);
    }

    private static class CollectionInfo {
        public String collectionClassName;
        public String serializerName;
        public QName elementTypeName;

        CollectionInfo(String collectionClassName, String serializerName, QName elementTypeName) {
            this.collectionClassName = collectionClassName;
            this.serializerName = serializerName;
            this.elementTypeName = elementTypeName;
        }
    }
}

