/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator.writer;

import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorConstants;
import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorException;
import com.nec.webotx.webservice.xml.rpc.processor.generator.Names;
import com.nec.webotx.webservice.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralType;
import com.nec.webotx.webservice.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class LiteralEnumerationSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private LiteralType dataType;

    public LiteralEnumerationSerializerWriter(String basePackage, LiteralType type, Names names) {
        super(type, names);
        this.dataType = type;
        String serializerName = names.typeObjectSerializerClassName(basePackage, type);
        this.serializerMemberName = names.getClassMemberName(serializerName, type);
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException, GeneratorException {
        LiteralType type = (LiteralType)this.type;
        this.declareType(p, typeName, type.getName(), false, false);
        String encoder = type.getJavaType().getName() + "_Encoder";
        p.plnI(this.serializerName() + " " + serName + " = new " + "LiteralSimpleTypeSerializer" + "(" + typeName + ", \"\",");
        p.pln(encoder + ".getInstance());");
        p.pO();
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException, GeneratorException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }
}

