/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.generator.writer;

import com.nec.webotx.webservice.xml.rpc.processor.generator.GeneratorConstants;
import com.nec.webotx.webservice.xml.rpc.processor.generator.Names;
import com.nec.webotx.webservice.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.nec.webotx.webservice.xml.rpc.processor.model.literal.LiteralType;
import com.nec.webotx.webservice.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class LiteralFragmentSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private LiteralType dataType;

    public LiteralFragmentSerializerWriter(LiteralFragmentType type, Names names) {
        super(type, names);
        this.dataType = type;
        String serializerName = "LiteralFragmentSerializer";
        this.serializerMemberName = names.getLiteralFragmentTypeSerializerMemberName(type);
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        LiteralFragmentType type = (LiteralFragmentType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        this.declareType(p, typeName, type.getName(), false, false);
        p.pln(this.serializerName() + " " + serName + " = new " + "LiteralFragmentSerializer" + "(" + typeName + ", " + nillable + ", \"\");");
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }
}

