/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.modeler.modelfile;

import com.nec.webotx.webservice.xml.rpc.processor.config.ModelFileModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.model.Model;
import com.nec.webotx.webservice.xml.rpc.processor.model.ModelException;
import com.nec.webotx.webservice.xml.rpc.processor.model.exporter.ModelImporter;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.Modeler;
import com.nec.webotx.webservice.xml.rpc.processor.modeler.ModelerException;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.nec.webotx.webservice.xml.rpc.util.localization.LocalizableMessageFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ModelFileModeler
implements Modeler {
    private ModelFileModelInfo _modelInfo;
    private Properties _options;
    private LocalizableMessageFactory _messageFactory;
    private ProcessorEnvironment _env;

    public ModelFileModeler(ModelFileModelInfo modelInfo, Properties options) {
        this._modelInfo = modelInfo;
        this._options = options;
        this._messageFactory = new LocalizableMessageFactory("com.nec.webotx.webservice.xml.rpc.resources.modeler");
        this._env = (ProcessorEnvironment)modelInfo.getParent().getEnvironment();
    }

    public Model buildModel() {
        try {
            URL url = null;
            try {
                url = new URL(this._modelInfo.getLocation());
            }
            catch (MalformedURLException e) {
                url = new File(this._modelInfo.getLocation()).toURL();
            }
            InputStream is = url.openStream();
            ModelImporter im = new ModelImporter(url.openStream());
            Model model = im.doImport();
            if (model.getSource() != null) {
                this._options.setProperty("sourceVersion", model.getSource());
            }
            return model;
        }
        catch (IOException e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
        catch (ModelException e) {
            throw new ModelerException(e);
        }
    }
}

