/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.streaming;

import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.FactoryConfigurationError;

public abstract class XMLWriterFactory {
    private static XMLWriterFactory _instance;

    protected XMLWriterFactory() {
    }

    public static XMLWriterFactory newInstance() {
        if (_instance == null) {
            String factoryImplName = XMLWriterFactory.getFactoryImplName();
            try {
                Class<?> clazz = Class.forName(factoryImplName);
                _instance = (XMLWriterFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new FactoryConfigurationError(e);
            }
            catch (IllegalAccessException e) {
                throw new FactoryConfigurationError(e);
            }
            catch (InstantiationException e) {
                throw new FactoryConfigurationError(e);
            }
        }
        return _instance;
    }

    private static String getFactoryImplName() {
        String factoryImplName;
        try {
            factoryImplName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterFactory", "com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterFactoryImpl");
                }
            });
        }
        catch (AccessControlException e) {
            factoryImplName = "com.nec.webotx.webservice.xml.rpc.streaming.XMLWriterFactoryImpl";
        }
        return factoryImplName;
    }

    public abstract XMLWriter createXMLWriter(OutputStream var1);

    public abstract XMLWriter createXMLWriter(OutputStream var1, String var2);

    public abstract XMLWriter createXMLWriter(OutputStream var1, String var2, boolean var3);
}

