/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.tools.wsdlp;

import com.nec.webotx.webservice.xml.rpc.util.Debug;
import com.nec.webotx.webservice.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.nec.webotx.webservice.xml.rpc.util.localization.Localizer;
import com.nec.webotx.webservice.xml.rpc.util.localization.Resources;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.WSDLDocument;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.schema.SchemaDocument;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.Entity;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.ParseException;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.ParserListener;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.ValidationException;
import com.nec.webotx.webservice.xml.rpc.wsdl.parser.SOAPEntityReferenceValidator;
import com.nec.webotx.webservice.xml.rpc.wsdl.parser.SchemaParser;
import com.nec.webotx.webservice.xml.rpc.wsdl.parser.SchemaWriter;
import com.nec.webotx.webservice.xml.rpc.wsdl.parser.WSDLParser;
import com.nec.webotx.webservice.xml.rpc.wsdl.parser.WSDLWriter;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class Main {
    private boolean _succeeded;
    private Localizer _localizer;
    private Resources _resources = new Resources("com.nec.webotx.webservice.xml.rpc.resources.wsdlp");
    private String _sourceFilename;
    private boolean _shouldValidate;
    private boolean _beVerbose;
    private boolean _echo;
    private boolean _parseSchema;
    private boolean _useWSIBasicProfile;

    public static void main(String[] args) {
        try {
            Main tool = new Main();
            tool.run(args);
            System.exit(tool.succeeded() ? 0 : 1);
        }
        catch (MissingResourceException e) {
            System.err.println("wsdlp: resources not available");
            System.exit(2);
        }
    }

    public Main() throws MissingResourceException {
        this._localizer = new Localizer();
    }

    public boolean succeeded() {
        return this._succeeded;
    }

    public void run(String[] args) {
        block16: {
            this._succeeded = false;
            if (!this.processArgs(args)) {
                return;
            }
            try {
                if (this._parseSchema) {
                    SchemaParser parser = new SchemaParser();
                    if (this._shouldValidate) {
                        parser.setFollowImports(true);
                    }
                    InputSource inputSource = new InputSource(new File(this._sourceFilename).toURL().toString());
                    SchemaDocument document = parser.parse(inputSource);
                    document.validateLocally();
                    if (this._shouldValidate) {
                        document.validate(new SOAPEntityReferenceValidator());
                    }
                    if (this._echo) {
                        SchemaWriter writer = new SchemaWriter();
                        writer.write(document, System.out);
                    }
                } else {
                    WSDLParser parser = new WSDLParser();
                    if (this._beVerbose) {
                        parser.addParserListener(new ParserListener(){

                            public void ignoringExtension(QName name, QName parent) {
                                System.err.println(Main.this._resources.getString("message.ignoring", new String[]{name.getLocalPart(), name.getNamespaceURI()}));
                            }

                            public void doneParsingEntity(QName element, Entity entity) {
                                System.err.println(Main.this._resources.getString("message.processed", new String[]{element.getLocalPart(), element.getNamespaceURI()}));
                            }
                        });
                    }
                    if (this._shouldValidate) {
                        parser.setFollowImports(true);
                    }
                    InputSource inputSource = new InputSource(new File(this._sourceFilename).toURL().toString());
                    WSDLDocument document = parser.parse(inputSource, this._useWSIBasicProfile);
                    document.validateLocally();
                    if (this._shouldValidate) {
                        document.validate(new SOAPEntityReferenceValidator());
                    }
                    if (this._echo) {
                        WSDLWriter writer = new WSDLWriter();
                        writer.write(document, System.out);
                    }
                }
                this._succeeded = true;
            }
            catch (ParseException e) {
                System.err.println(this._resources.getString("error.parsing", this._localizer.localize(e)));
            }
            catch (ValidationException e) {
                System.err.println(this._resources.getString("error.validation", this._localizer.localize(e)));
            }
            catch (JAXRPCExceptionBase e) {
                System.err.println(this._resources.getString("error.generic", this._localizer.localize(e)));
            }
            catch (IOException e) {
                System.err.println(this._resources.getString("error.io", e.toString()));
            }
            catch (Exception e) {
                System.err.println(this._resources.getString("error.generic", e.toString()));
                if (!Debug.enabled()) break block16;
                e.printStackTrace();
            }
        }
    }

    private boolean processArgs(String[] args) {
        if (args.length == 0) {
            this.help();
            return false;
        }
        for (int ac = 0; ac < args.length; ++ac) {
            String arg = args[ac];
            if (arg.startsWith("-")) {
                if (arg.equals("-help")) {
                    this.help();
                    this._succeeded = true;
                    return false;
                }
                if (arg.equals("-echo")) {
                    this._echo = true;
                    continue;
                }
                if (arg.equals("-schema")) {
                    this._parseSchema = true;
                    continue;
                }
                if (arg.equals("-validate")) {
                    this._shouldValidate = true;
                    continue;
                }
                if (arg.equals("-v") || arg.equals("-verbose")) {
                    this._beVerbose = true;
                    continue;
                }
                if (arg.equals("-version")) {
                    System.err.println(this._resources.getString("message.version"));
                    this._succeeded = true;
                    return false;
                }
                if (arg.equals("-wsi")) {
                    this._useWSIBasicProfile = true;
                    continue;
                }
                this.usageError("error.invalidOption", arg);
                return false;
            }
            if (this._sourceFilename != null) {
                this.usageError("error.multipleFilenames", null);
                return false;
            }
            this._sourceFilename = arg;
        }
        if (this._sourceFilename == null) {
            this.usageError("error.missingFilename", null);
            return false;
        }
        return true;
    }

    private void help() {
        System.err.println(this._resources.getString("message.header"));
        System.err.println(this._resources.getString("message.usage"));
    }

    private void printError(String msg) {
        System.err.println(this._resources.getString("message.name") + ": " + msg);
    }

    private void usageError(String key, String arg) {
        this.printError(this._resources.getString(key, arg));
    }
}

