/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.messaging.saaj.soap;

import com.nec.webotx.webservice.xml.messaging.saaj.SOAPExceptionImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.MessageImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.ver1_1.Message1_1Impl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.ver1_2.Message1_2Impl;
import com.nec.webotx.webservice.xml.messaging.saaj.util.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends MessageFactory {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.nec.webotx.webservice.xml.messaging.saaj.soap.LocalStrings");
    protected static OutputStream listener;

    public static OutputStream listen(OutputStream newListener) {
        OutputStream oldListener = listener;
        listener = newListener;
        return oldListener;
    }

    public SOAPMessage createMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(MimeHeaders headers, InputStream in) throws SOAPException, IOException {
        String contentTypeString = MessageImpl.getContentType(headers);
        if (listener != null) {
            in = new TeeInputStream(in, listener);
        }
        try {
            ContentType contentType = new ContentType(contentTypeString);
            if (MessageImpl.isSoap1_1Content(contentType)) {
                return new Message1_1Impl(headers, in);
            }
            if (MessageImpl.isSoap1_2Content(contentType)) {
                return new Message1_2Impl(headers, in);
            }
            log.severe("SAAJ0530.soap.unknown.Content-Type");
            throw new SOAPExceptionImpl("Unrecognized Content-Type");
        }
        catch (ParseException e) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + e.getMessage());
        }
    }
}

