/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.messaging.saaj.soap.impl;

import com.nec.webotx.webservice.xml.messaging.saaj.SOAPExceptionImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.SOAPDocument;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.ElementFactory;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.ElementImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.impl.HeaderElementImpl;
import com.nec.webotx.webservice.xml.messaging.saaj.soap.name.NameImpl;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HeaderImpl
extends ElementImpl
implements SOAPHeader {
    protected static final boolean MUST_UNDERSTAND_ONLY = false;

    protected HeaderImpl(SOAPDocumentImpl ownerDoc, NameImpl name) {
        super(ownerDoc, name);
    }

    protected abstract SOAPHeaderElement createHeaderElement(Name var1) throws SOAPException;

    protected abstract NameImpl getNotUnderstoodName();

    protected abstract NameImpl getUpgradeName();

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        String uri;
        SOAPElement newHeaderElement = ElementFactory.createNamedElement(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), name.getLocalName(), name.getPrefix(), name.getURI());
        if (newHeaderElement == null || !(newHeaderElement instanceof SOAPHeaderElement)) {
            newHeaderElement = this.createHeaderElement(name);
        }
        if ((uri = newHeaderElement.getElementName().getURI()) == null || "".equals(uri)) {
            log.severe("SAAJ0131.impl.header.elems.ns.qualified");
            throw new SOAPExceptionImpl("HeaderElements must be namespace qualified");
        }
        this.addNode((Node)newHeaderElement);
        return (SOAPHeaderElement)newHeaderElement;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        return this.addHeaderElement(name);
    }

    public Iterator examineHeaderElements(String actor) {
        return this.getHeaderElementsForActor(actor, false, false);
    }

    public Iterator extractHeaderElements(String actor) {
        return this.getHeaderElementsForActor(actor, true, false);
    }

    protected Iterator getHeaderElementsForActor(String actor, boolean detach, boolean mustUnderstand) {
        if (actor == null || actor.equals("")) {
            log.severe("SAAJ0132.impl.invalid.value.for.actor.or.role");
            throw new IllegalArgumentException("Invalid value for actor or role");
        }
        return this.getHeaderElements(actor, detach, mustUnderstand);
    }

    protected Iterator getHeaderElements(String actor, boolean detach, boolean mustUnderstand) {
        ArrayList<HeaderElementImpl> elementList = new ArrayList<HeaderElementImpl>();
        Iterator eachChild = this.getChildElements();
        Object currentChild = this.iterate(eachChild);
        while (currentChild != null) {
            if (!(currentChild instanceof SOAPHeaderElement)) {
                currentChild = this.iterate(eachChild);
                continue;
            }
            HeaderElementImpl currentElement = (HeaderElementImpl)((Object)currentChild);
            currentChild = this.iterate(eachChild);
            boolean isMustUnderstandMatching = !mustUnderstand || currentElement.getMustUnderstand();
            boolean doAdd = false;
            if (actor == null && isMustUnderstandMatching) {
                doAdd = true;
            } else {
                String currentActor = currentElement.getActorOrRole();
                if (currentActor == null || currentActor.equals("")) {
                    currentActor = "http://schemas.xmlsoap.org/soap/actor/next";
                }
                if (currentActor.equalsIgnoreCase(actor) && isMustUnderstandMatching) {
                    doAdd = true;
                }
            }
            if (!doAdd) continue;
            elementList.add(currentElement);
            if (!detach) continue;
            currentElement.detachNode();
        }
        return elementList.listIterator();
    }

    private Object iterate(Iterator each) {
        return each.hasNext() ? each.next() : null;
    }

    public void setParentElement(SOAPElement element) throws SOAPException {
        if (!(element instanceof SOAPEnvelope)) {
            log.severe("SAAJ0133.impl.header.parent.mustbe.envelope");
            throw new SOAPException("Parent of SOAPHeader has to be a SOAPEnvelope");
        }
        super.setParentElement(element);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPElement element = super.addChildElement(localName);
        String uri = element.getElementName().getURI();
        if (uri == null || "".equals(uri)) {
            log.severe("SAAJ0134.impl.header.elems.ns.qualified");
            throw new SOAPExceptionImpl("HeaderElements must be namespace qualified");
        }
        return element;
    }

    public Iterator examineAllHeaderElements() {
        return this.getHeaderElements(null, false, false);
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        return this.getHeaderElements(actor, false, true);
    }

    public Iterator extractAllHeaderElements() {
        return this.getHeaderElements(null, true, false);
    }

    protected SOAPElement convertToSoapElement(Element element) {
        SOAPHeaderElement headerElement;
        if (element instanceof SOAPHeaderElement) {
            return (SOAPElement)element;
        }
        try {
            headerElement = this.createHeaderElement(NameImpl.copyElementName(element));
        }
        catch (SOAPException e) {
            throw new ClassCastException("Could not convert Element to SOAPHeaderElement: " + e.getMessage());
        }
        return HeaderImpl.replaceElementWithSOAPElement(element, (ElementImpl)headerElement);
    }
}

