/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.client.dii;

import com.nec.webotx.webservice.xml.rpc.client.ClientTransport;
import com.nec.webotx.webservice.xml.rpc.client.ClientTransportFactory;
import com.nec.webotx.webservice.xml.rpc.client.StreamingSender;
import com.nec.webotx.webservice.xml.rpc.client.StreamingSenderState;
import com.nec.webotx.webservice.xml.rpc.client.dii.BasicCall;
import com.nec.webotx.webservice.xml.rpc.client.dii.CallInvoker;
import com.nec.webotx.webservice.xml.rpc.client.dii.CallPropertyConstants;
import com.nec.webotx.webservice.xml.rpc.client.dii.CallRequest;
import com.nec.webotx.webservice.xml.rpc.client.http.HttpClientTransportFactory;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCDeserializer;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationState;
import com.nec.webotx.webservice.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.nec.webotx.webservice.xml.rpc.soap.message.InternalSOAPMessage;
import com.nec.webotx.webservice.xml.rpc.soap.message.SOAPBlockInfo;
import com.nec.webotx.webservice.xml.rpc.soap.message.SOAPMessageContext;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class CallInvokerImpl
extends StreamingSender
implements CallInvoker,
CallPropertyConstants {
    private static ClientTransportFactory defaultTransportFactory = null;
    private static final String BASIC_CALL_PROPERTY = "com.nec.webotx.webservice.xml.rpc.client.dii.BasicCall";
    protected JAXRPCDeserializer faultDeserializer;
    protected JAXRPCDeserializer responseDeserializer;
    protected ClientTransportFactory transportFactory = defaultTransportFactory;
    protected ClientTransport clientTransport;
    protected String defaultEnvEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    protected String implicitEnvEncodingStyle = null;
    protected String[] additionalNamespaces = null;

    public static void setDefaultTransportFactory(ClientTransportFactory factory) {
        defaultTransportFactory = factory;
    }

    public SOAPResponseStructure doInvoke(CallRequest callInfo, JAXRPCSerializer requestSerializer, JAXRPCDeserializer responseDeserializer, JAXRPCDeserializer faultDeserializer) throws Exception {
        this.responseDeserializer = responseDeserializer;
        this.faultDeserializer = faultDeserializer;
        BasicCall call = callInfo.call;
        StreamingSenderState state = this.setupRequest(callInfo, requestSerializer);
        this._send(call.getTargetEndpointAddress(), state);
        SOAPResponseStructure responseStruct = null;
        Object responseObject = state.getResponse().getBody().getValue();
        responseStruct = responseObject instanceof SOAPDeserializationState ? (SOAPResponseStructure)((SOAPDeserializationState)responseObject).getInstance() : (SOAPResponseStructure)responseObject;
        return responseStruct;
    }

    protected void _handleRuntimeExceptionInSend(RuntimeException rex) throws Exception {
        if (rex instanceof JAXRPCException) {
            throw rex;
        }
        super._handleRuntimeExceptionInSend(rex);
    }

    public void doInvokeOneWay(CallRequest callInfo, JAXRPCSerializer requestSerializer) throws Exception {
        BasicCall call = callInfo.call;
        StreamingSenderState state = this.setupRequest(callInfo, requestSerializer);
        this._sendOneWay(call.getTargetEndpointAddress(), state);
    }

    private StreamingSenderState setupRequest(CallRequest callInfo, JAXRPCSerializer requestSerializer) throws Exception {
        BasicCall call = callInfo.call;
        String encodingStyle = (String)call.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        String operationStyle = (String)call.getProperty("javax.xml.rpc.soap.operation.style");
        StreamingSenderState state = this._start(call.getHandlerChain());
        InternalSOAPMessage request = state.getRequest();
        if (this.isRPCLiteral(operationStyle, encodingStyle)) {
            this.setNamespaceDeclarations("ns0", call.getOperationName().getNamespaceURI());
        }
        if ("".equals(encodingStyle)) {
            this.setImplicitEnvelopeEncodingStyle("");
            this.setDefaultEnvelopeEncodingStyle(null);
        }
        SOAPBlockInfo bodyBlock = null;
        bodyBlock = this.isRPC(operationStyle, encodingStyle) ? new SOAPBlockInfo(call.getOperationName()) : new SOAPBlockInfo(null);
        bodyBlock.setValue(callInfo.request);
        bodyBlock.setSerializer(requestSerializer);
        request.setBody(bodyBlock);
        SOAPMessageContext messageContext = state.getMessageContext();
        messageContext.setProperty(BASIC_CALL_PROPERTY, call);
        if (this.isRPCLiteral(operationStyle, encodingStyle)) {
            messageContext.setProperty("com.nec.webotx.webservice.xml.rpc.client.responseQName", new QName(call.getOperationName().getNamespaceURI(), call.getOperationName().getLocalPart() + "Response"));
        }
        return state;
    }

    protected void _preSendingHook(StreamingSenderState state) throws Exception {
        Object cookieJar;
        Object maintainSession;
        Object verification;
        Object encoding;
        Boolean isSOAPActionUsed;
        Object operation;
        Object endpoint;
        Object password;
        BasicCall call = (BasicCall)state.getMessageContext().getProperty(BASIC_CALL_PROPERTY);
        SOAPMessageContext messageContext = state.getMessageContext();
        Object username = call.getProperty("javax.xml.rpc.security.auth.username");
        if (username != null) {
            messageContext.setProperty("javax.xml.rpc.security.auth.username", username);
        }
        if ((password = call.getProperty("javax.xml.rpc.security.auth.password")) != null) {
            messageContext.setProperty("javax.xml.rpc.security.auth.password", password);
        }
        if ((endpoint = call.getProperty("javax.xml.rpc.endpoint")) != null) {
            messageContext.setProperty("javax.xml.rpc.endpoint", endpoint);
        }
        if ((operation = call.getProperty("javax.xml.rpc.soap.operation.style")) != null) {
            messageContext.setProperty("javax.xml.rpc.soap.operation.style", operation);
        }
        if ((isSOAPActionUsed = (Boolean)call.getRequiredProperty("javax.xml.rpc.soap.http.soapaction.use")).booleanValue()) {
            messageContext.setProperty("http.soap.action", call.getRequiredProperty("javax.xml.rpc.soap.http.soapaction.uri"));
        }
        if ((encoding = call.getProperty("javax.xml.rpc.encodingstyle.namespace.uri")) != null) {
            messageContext.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", encoding);
        }
        if ((verification = call.getProperty("com.nec.webotx.webservice.xml.rpc.client.http.HostnameVerificationProperty")) != null) {
            messageContext.setProperty("com.nec.webotx.webservice.xml.rpc.client.http.HostnameVerificationProperty", verification);
        }
        if ((maintainSession = call.getProperty("javax.xml.rpc.session.maintain")) != null) {
            messageContext.setProperty("javax.xml.rpc.session.maintain", maintainSession);
        }
        if (maintainSession != null && maintainSession.equals(Boolean.TRUE) && (cookieJar = call.getProperty("com.nec.webotx.webservice.xml.rpc.client.http.CookieJar")) != null) {
            messageContext.setProperty("com.nec.webotx.webservice.xml.rpc.client.http.CookieJar", cookieJar);
        }
    }

    protected void _postSendingHook(StreamingSenderState state) throws Exception {
        Object cookieJar;
        BasicCall call = (BasicCall)state.getMessageContext().getProperty(BASIC_CALL_PROPERTY);
        Object maintainSession = call.getProperty("javax.xml.rpc.session.maintain");
        if (maintainSession != null && maintainSession.equals(Boolean.TRUE) && (cookieJar = call.getProperty("com.nec.webotx.webservice.xml.rpc.client.http.CookieJar")) == null) {
            SOAPMessageContext messageContext = state.getMessageContext();
            cookieJar = messageContext.getProperty("com.nec.webotx.webservice.xml.rpc.client.http.CookieJar");
            call.setProperty("com.nec.webotx.webservice.xml.rpc.client.http.CookieJar", cookieJar);
        }
    }

    public ClientTransportFactory _getTransportFactory() {
        if (this.transportFactory == null) {
            this.transportFactory = new HttpClientTransportFactory();
        }
        return this.transportFactory;
    }

    public void _setTransportFactory(ClientTransportFactory factory) {
        this.transportFactory = factory;
        this.clientTransport = null;
    }

    public ClientTransport _getTransport() {
        if (this.clientTransport == null) {
            this.clientTransport = this._getTransportFactory().create();
        }
        return this.clientTransport;
    }

    protected void _readFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        String operationStyle = (String)state.getMessageContext().getProperty("javax.xml.rpc.soap.operation.style");
        String encoding = (String)state.getMessageContext().getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        QName responseQName = null;
        if (this.isRPCLiteral(operationStyle, encoding)) {
            responseQName = (QName)state.getMessageContext().getProperty("com.nec.webotx.webservice.xml.rpc.client.responseQName");
        }
        Object responseStructObj = this.getResponseDeserializer().deserialize(responseQName, bodyReader, deserializationContext);
        SOAPBlockInfo bodyBlock = new SOAPBlockInfo(responseQName);
        bodyBlock.setValue(responseStructObj);
        state.getResponse().setBody(bodyBlock);
    }

    protected JAXRPCDeserializer getFaultDeserializer() {
        return this.faultDeserializer;
    }

    protected JAXRPCDeserializer getResponseDeserializer() {
        return this.responseDeserializer;
    }

    public String _getDefaultEnvelopeEncodingStyle() {
        return this.defaultEnvEncodingStyle;
    }

    void setDefaultEnvelopeEncodingStyle(String style) {
        this.defaultEnvEncodingStyle = style;
    }

    public void setImplicitEnvelopeEncodingStyle(String style) {
        this.implicitEnvEncodingStyle = style;
    }

    public String _getImplicitEnvelopeEncodingStyle() {
        return this.implicitEnvEncodingStyle;
    }

    protected String[] _getNamespaceDeclarations() {
        return this.additionalNamespaces;
    }

    protected void setNamespaceDeclarations(String pre, String name) {
        this.additionalNamespaces = new String[]{pre, name};
    }

    boolean isDocumentLiteral(String operationStyle, String encodingStyle) {
        return "document".equalsIgnoreCase(operationStyle) && "".equals(encodingStyle);
    }

    boolean isRPCLiteral(String operationStyle, String encodingStyle) {
        return "rpc".equalsIgnoreCase(operationStyle) && "".equals(encodingStyle);
    }

    boolean isRPC(String operationStyle, String encodingStyle) {
        return "rpc".equalsIgnoreCase(operationStyle);
    }
}

