/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.encoding.soap;

import com.nec.webotx.webservice.xml.rpc.encoding.DeserializationException;
import com.nec.webotx.webservice.xml.rpc.encoding.Initializable;
import com.nec.webotx.webservice.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCDeserializer;
import com.nec.webotx.webservice.xml.rpc.encoding.JAXRPCSerializer;
import com.nec.webotx.webservice.xml.rpc.encoding.ObjectSerializerBase;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationContext;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPDeserializationState;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPInstanceBuilder;
import com.nec.webotx.webservice.xml.rpc.encoding.SOAPSerializationContext;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLWriter;
import com.nec.webotx.webservice.xml.rpc.util.StructMap;
import com.nec.webotx.webservice.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class StructMapSerializer
extends ObjectSerializerBase
implements Initializable {
    protected InternalTypeMappingRegistry registry;

    public StructMapSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type, encodeType, isNullable, encodingStyle);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        StructMap struct = (StructMap)instance;
        Iterator eachKey = struct.keys().iterator();
        Iterator eachValue = struct.values().iterator();
        while (eachKey.hasNext()) {
            Object value = eachValue.next();
            QName key = (QName)eachKey.next();
            if (value != null) {
                JAXRPCSerializer serializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, value.getClass());
                serializer.serialize(value, key, null, writer, context);
                continue;
            }
            this.serializeNull(key, writer, context);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        StructMap instance = new StructMap();
        StructMapBuilder builder = null;
        boolean isComplete = true;
        int memberIndex = 0;
        while (reader.nextElementContent() != 2) {
            QName key = reader.getName();
            if (!StructMapSerializer.getNullStatus(reader)) {
                JAXRPCDeserializer deserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, StructMapSerializer.getType(reader));
                Object member = deserializer.deserialize(key, reader, context);
                if (member instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new StructMapBuilder(instance);
                    }
                    state = StructMapSerializer.registerWithMemberState(instance, state, member, memberIndex, builder);
                    isComplete = false;
                }
                instance.put(key, member);
                continue;
            }
            instance.put(key, (Object)null);
        }
        return isComplete ? instance : state;
    }

    protected class StructMapBuilder
    implements SOAPInstanceBuilder {
        StructMap instance;

        StructMapBuilder(StructMap instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                this.instance.set(index, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
            instance = (StructMap)instance;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

