/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.processor.config.parser;

import com.nec.webotx.webservice.xml.rpc.processor.config.ModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.WSDLModelInfo;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.Constants;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.HandlerChainInfoData;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ModelInfoParser;
import com.nec.webotx.webservice.xml.rpc.processor.config.parser.ParserUtil;
import com.nec.webotx.webservice.xml.rpc.processor.util.ProcessorEnvironment;
import com.nec.webotx.webservice.xml.rpc.streaming.XMLReader;

public class WSDLModelInfoParser
extends ModelInfoParser {
    public WSDLModelInfoParser(ProcessorEnvironment env) {
        super(env);
    }

    public ModelInfo parse(XMLReader reader) {
        WSDLModelInfo modelInfo = new WSDLModelInfo();
        String location = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
        modelInfo.setLocation(location);
        String packageName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "packageName");
        modelInfo.setJavaPackageName(packageName);
        boolean gotTypeMappingRegistry = false;
        boolean gotHandlerChains = false;
        boolean gotNamespaceMappingRegistry = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_TYPE_MAPPING_REGISTRY)) {
                if (gotTypeMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.setTypeMappingRegistry(this.parseTypeMappingRegistryInfo(reader));
                gotTypeMappingRegistry = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                if (gotHandlerChains) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                HandlerChainInfoData data = this.parseHandlerChainInfoData(reader);
                modelInfo.setClientHandlerChainInfo(data.getClientHandlerChainInfo());
                modelInfo.setServerHandlerChainInfo(data.getServerHandlerChainInfo());
                gotHandlerChains = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_NAMESPACE_MAPPING_REGISTRY)) {
                if (gotNamespaceMappingRegistry) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                    continue;
                }
                modelInfo.setNamespaceMappingRegistry(this.parseNamespaceMappingRegistryInfo(reader));
                gotNamespaceMappingRegistry = true;
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return modelInfo;
    }
}

