/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.tools.ant;

import com.nec.webotx.webservice.xml.rpc.tools.wsdeploy.DeployTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Wsdeploy
extends MatchingTask {
    private String features = null;
    protected Path compileClasspath = null;
    private boolean keep = false;
    private File tmpDir = null;
    private String source = null;
    private File outWarFile = null;
    protected boolean verbose = false;
    protected boolean version = false;
    private File warFile = null;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public String getF() {
        return this.getFeatures();
    }

    public void setF(String features) {
        this.setFeatures(features);
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path classpath) {
        this.setClasspath(classpath);
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String version) {
        this.source = version;
    }

    public File getOutWarFile() {
        return this.outWarFile;
    }

    public void setOutWarFile(File outWarFile) {
        this.outWarFile = outWarFile;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public File getInWarFile() {
        return this.warFile;
    }

    public void setInWarFile(File warFile) {
        this.warFile = warFile;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path classpath = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                classpath.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return classpath;
    }

    private Commandline setupWsdeployCommand(String[] options) {
        Path classpath;
        Commandline cmd = new Commandline();
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                cmd.createArgument().setValue(options[i]);
            }
        }
        if ((classpath = this.getClasspath()) != null && !classpath.toString().equals("")) {
            cmd.createArgument().setValue("-classpath");
            cmd.createArgument().setPath(classpath);
        }
        if (this.getKeep()) {
            cmd.createArgument().setValue("-keep");
        }
        if (this.getFeatures() != null && !this.getFeatures().equals("")) {
            cmd.createArgument().setValue("-features:" + this.getFeatures());
        }
        if (null != this.getTmpDir() && !this.getTmpDir().equals("")) {
            cmd.createArgument().setValue("-tmpdir");
            cmd.createArgument().setFile(this.getTmpDir());
        }
        if (this.getSource() != null && !this.getSource().equals("")) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(this.getSource());
        }
        if (this.getOutWarFile() != null && !this.getOutWarFile().equals("")) {
            cmd.createArgument().setValue("-o");
            cmd.createArgument().setFile(this.getOutWarFile());
        }
        if (this.getVerbose()) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            cmd.createArgument().setValue("-version");
        }
        if (this.warFile != null) {
            cmd.createArgument().setValue(this.warFile.toString());
        }
        return cmd;
    }

    private Commandline setupWsdeployCommand() {
        return this.setupWsdeployCommand(null);
    }

    public void execute() throws BuildException {
        if (!(this.getVersion() || this.warFile != null && this.warFile.exists())) {
            throw new BuildException("wsdeploy input war file does not exist!", this.location);
        }
        Commandline cmd = this.setupWsdeployCommand();
        if (this.verbose) {
            this.log("command line: wsdeploy " + cmd.toString());
        }
        LogOutputStream logstr = new LogOutputStream((Task)this, 1);
        try {
            DeployTool depTool = new DeployTool((OutputStream)logstr, "wsdeploy");
            boolean ok = depTool.run(cmd.getArguments());
            if (!ok) {
                if (!this.verbose) {
                    this.log("Command invoked: wsdeploy " + cmd.toString());
                }
                throw new BuildException("wsdeploy failed", this.location);
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error starting wsdeploy: ", (Throwable)ex, this.getLocation());
        }
        finally {
            try {
                logstr.close();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

