/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.rpc.wsdl.document;

import com.nec.webotx.webservice.xml.rpc.wsdl.document.Documentation;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Fault;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Input;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.OperationStyle;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.Output;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.WSDLConstants;
import com.nec.webotx.webservice.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.Entity;
import com.nec.webotx.webservice.xml.rpc.wsdl.framework.EntityAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class Operation
extends Entity {
    private Documentation _documentation;
    private String _name;
    private Input _input;
    private Output _output;
    private List _faults = new ArrayList();
    private OperationStyle _style;
    private String _parameterOrder;
    private String _uniqueKey;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this._name);
            sb.append(' ');
            if (this._input != null) {
                sb.append(this._input.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Response");
                }
            }
            sb.append(' ');
            if (this._output != null) {
                sb.append(this._output.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Response");
                }
            }
            this._uniqueKey = sb.toString();
        }
        return this._uniqueKey;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle s) {
        this._style = s;
    }

    public Input getInput() {
        return this._input;
    }

    public void setInput(Input i) {
        this._input = i;
    }

    public Output getOutput() {
        return this._output;
    }

    public void setOutput(Output o) {
        this._output = o;
    }

    public void addFault(Fault f) {
        this._faults.add(f);
    }

    public Iterator faults() {
        return this._faults.iterator();
    }

    public String getParameterOrder() {
        return this._parameterOrder;
    }

    public void setParameterOrder(String s) {
        this._parameterOrder = s;
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        super.withAllSubEntitiesDo(action);
        if (this._input != null) {
            action.perform(this._input);
        }
        if (this._output != null) {
            action.perform(this._output);
        }
        Iterator iter = this._faults.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        if (this._input != null) {
            this._input.accept(visitor);
        }
        if (this._output != null) {
            this._output.accept(visitor);
        }
        Iterator iter = this._faults.iterator();
        while (iter.hasNext()) {
            ((Fault)iter.next()).accept(visitor);
        }
        visitor.postVisit(this);
    }

    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
            if (this._parameterOrder != null) {
                this.failValidation("validation.invalidAttribute", "parameterOrder");
            }
        } else if (this._style == OperationStyle.NOTIFICATION && this._parameterOrder != null) {
            this.failValidation("validation.invalidAttribute", "parameterOrder");
        }
    }
}

