/*
 * Decompiled with CFR 0.152.
 */
package com.nec.webotx.webservice.xml.messaging.saaj.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        String bundleName = packageName + ".LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName);
    }

    private StringManager(String packageName, ClassLoader cl) {
        String bundleName = packageName + ".LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
    }

    private StringManager(String packageName, Locale loc) {
        String bundleName = packageName + ".LocalStrings";
        this.bundle = ResourceBundle.getBundle(bundleName, loc);
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        String str = null;
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = "[cannot find message associated with key '" + key + "' due to " + mre + "]";
        }
        return str;
    }

    public String getString(String key, Object[] args) {
        String iString = null;
        String value = this.getString(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(String packageName, Locale loc) {
        StringManager mgr = (StringManager)managers.get(packageName + "_" + loc.toString());
        if (mgr == null) {
            mgr = new StringManager(packageName, loc);
            managers.put(packageName + "_" + loc.toString(), mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(String packageName, ClassLoader loader) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName, loader);
            managers.put(packageName, mgr);
        }
        return mgr;
    }
}

