package com.nec.webotx.webservice.sample;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

public class DIIHelloClient {

	private static String qnameService = "Hello";
	private static String qnamePort = "HelloPort";
	private static String BODY_NAMESPACE_VALUE = "http://sample/Hello";

	private static String ENCODING_STYLE_PROPERTY =
		"javax.xml.rpc.encodingstyle.namespace.uri";
	private static String NS_XSD = "http://www.w3.org/2001/XMLSchema";
	private static String URI_ENCODING =
		"http://schemas.xmlsoap.org/soap/encoding/";

	public static void main(String[] args) {

		try {

			ServiceFactory factory = ServiceFactory.newInstance();
			Service service = factory.createService(new QName(qnameService));
			QName port = new QName(qnamePort);
			Call call = service.createCall(port);
			call.setTargetEndpointAddress(
				"http://localhost/HelloService/Hello");
			call.setProperty(Call.SOAPACTION_USE_PROPERTY, new Boolean(true));
			call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");
			call.setProperty(ENCODING_STYLE_PROPERTY, URI_ENCODING);
			QName QNAME_TYPE_STRING = new QName(NS_XSD, "string");
			call.setReturnType(QNAME_TYPE_STRING);
			call.setOperationName(
				new QName(BODY_NAMESPACE_VALUE, "say_hello_Hello"));
			call.addParameter("String_1", QNAME_TYPE_STRING, ParameterMode.IN);
			System.out.println((String) call.invoke(new String[] { "webotx" }));

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

}
