package com.nec.webotx.webservice.sample;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

public class DynamicProxyHelloClient {

	public static void main(String[] args) {

		try {

			String nameSpaceUri = "http://sample/Hello";
			String serviceName = "Hello";
			String portName = "HelloPort";
			String urlString = "http://localhost/HelloService/Hello?wsdl";

			URL wsdlUrl = new URL(urlString);
			ServiceFactory serviceFactory = ServiceFactory.newInstance();
			Service service =
				serviceFactory.createService(
					wsdlUrl,
					new QName(nameSpaceUri, serviceName));

			Hello_PortType proxy =
				(Hello_PortType) service.getPort(
					new QName(nameSpaceUri, portName),
					Hello_PortType.class);

			System.out.println(proxy.say_hello_Hello("webotx"));

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

}
