
package sample;

import java.io.PrintStream;
import javax.xml.ws.handler.*;

public class HelloLogicalHandler implements LogicalHandler<LogicalMessageContext> {

    private static PrintStream out = System.out;

    public boolean handleMessage(LogicalMessageContext context) {
        // ʏ̃bZ[W̑MƂɌĂяo܂B
        logToSystemOut(context);
        return true;
    }
    public boolean handleFault(LogicalMessageContext context) {
        // FaultbZ[W̑MƂɌĂяo܂B
        logToSystemOut(context);
        return true;
    }
    public void close(MessageContext context) {
        // bZ[WAFaultbZ[WAOfBXpb`钼OɌĂяo܂B
        out.println("close: HelloLogicalHandler: MessageContext=" + context);
    }

    private void logToSystemOut(MessageContext context) {
        Boolean outboundProperty = (Boolean)
            context.get (MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outboundProperty.booleanValue()) {
            out.println("Outbound message: HelloLogicalHandler: MessageContext=" + context);
        } else {
            out.println("Inbound message: HelloLogicalHandler: MessageContext=" + context);
        }
    }
}
