
package sample;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import java.io.PrintStream;

public class HelloSOAPHandler implements SOAPHandler<SOAPMessageContext> {

    private static PrintStream out = System.out;

    public Set<QName> getHeaders() {
        return null;
    }
    public boolean handleMessage(SOAPMessageContext context) {
        // ʏ̃bZ[W̑MƂɌĂяo܂B
        logToSystemOut(context);
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        // FaultbZ[W̑MƂɌĂяo܂B
        logToSystemOut(context);
        return true;
    }

    public void close(MessageContext context) {
        // bZ[WAFaultbZ[WAOfBXpb`钼OɌĂяo܂B
        out.println("close: HelloSOAPHandler: MessageContext=" + context);
    }

    private void logToSystemOut(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean)
            context.get (MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outboundProperty.booleanValue()) {
            out.println("Outbound message: HelloSOAPHandler: MessageContext=" + context);
        } else {
            out.println("Inbound message: HelloSOAPHandler: MessageContext=" + context);
        }
    }

}
